<?php

$options = array(
	'colormag_home_icon_heading' => array(
		'type'         => 'customind-accordion',
		'title'        => esc_html__( 'Home Icon', 'colormag' ),
		'section'      => 'colormag_header_builder_home_icon',
		'sub_controls' => apply_filters(
			'colormag_home_icon_sub_controls',
			array(
				'colormag_menu_icon_logo'                  => array(
					'default' => 'home-icon',
					'type'    => 'customind-select',
					'title'   => esc_html__( 'Home Icon/Logo', 'colormag' ),
					'section' => 'colormag_header_builder_home_icon',
					'choices' => array(
						'home-icon' => esc_html__( 'Home Icon', 'colormag' ),
						'logo'      => esc_html__( 'Logo', 'colormag' ),
					),
				),
				'colormag_header_home_icon_color'          => array(
					'default'   => '',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Color', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_header_builder_home_icon',
					'condition' => array(
						'colormag_menu_icon_logo' => 'home-icon',
					),
				),
				'colormag_header_home_icon_bg_color_group' => array(
					'type'         => 'customind-color-group',
					'title'        => esc_html__( 'Background', 'colormag' ),
					'section'      => 'colormag_header_builder_home_icon',
					'sub_controls' => apply_filters(
						'colormag_header_home_icon__sub_controls',
						array(
							'colormag_header_home_icon_background_color' => array(
								'default' => '',
								'type'    => 'customind-color',
								'title'   => esc_html__( 'Normal', 'colormag' ),
								'section' => 'colormag_header_builder_home_icon',
							),
							'colormag_header_home_icon_hover_background_color' => array(
								'default' => '',
								'type'    => 'customind-color',
								'title'   => esc_html__( 'Hover', 'colormag' ),
								'section' => 'colormag_header_builder_home_icon',
							),
						),
					),
				),
				'colormag_primary_menu_logo'               => array(
					'default'     => '',
					'type'        => 'customind-image',
					'title'       => esc_html__( 'Upload', 'colormag' ),
					'section'     => 'colormag_header_builder_home_icon',
					'input_attrs' => array(
						'crop' => array(
							'width'  => 170,
							'height' => 60,
						),
					),
					'condition'   => array(
						'colormag_menu_icon_logo' => 'logo',
					),
				),
				'colormag_primary_menu_logo_height'        => array(
					'default'     => array(
						'size' => '',
						'unit' => 'px',
					),
					'type'        => 'customind-slider',
					'title'       => esc_html__( 'Height', 'colormag' ),
					'section'     => 'colormag_header_builder_home_icon',
					'transport'   => 'postMessage',
					'units'       => array( 'px' ),
					'defaultUnit' => 'px',
					'condition'   => array(
						'colormag_menu_icon_logo' => 'logo',
					),
				),
				'colormag_primary_menu_logo_spacing'       => array(
					'default'     => array(
						'size' => '',
						'unit' => 'px',
					),
					'type'        => 'customind-slider',
					'title'       => esc_html__( 'Spacing', 'colormag' ),
					'section'     => 'colormag_header_builder_home_icon',
					'transport'   => 'postMessage',
					'units'       => array( 'px' ),
					'defaultUnit' => 'px',
					'condition'   => array(
						'colormag_menu_icon_logo' => 'logo',
					),
				),
			)
		),
		'collapsible'  => apply_filters( 'colormag_home_icon_accordion_collapsible', false ),
	),
);

colormag_customind()->add_controls( $options );
